$josfHome = $PSScriptRoot
try {
  cd $josfHome
  $josfVersion = "josf-core.jar";

  Write-Host "To stop JOSF, press CTRL + C"

  Write-Host "Starting $josfVersion"
  Write-Host "                                                                                
                                 ,****,   *****                                 
                               ,**    ****.   .**                               
                               **,    ,***     **                               
                                .***************                                
                                       **                                       
                                       **                                       
                                  /////////////                                 
                   .////////////////////////////////////////,                   
                ////////////////////////////////////////////////.               
              //////////********************************//////////              
             ////////**************************************////////             
             ////////****/&&&&,&&&&************&@*****#&****///////.            
           ./,///////***@&&&&&@&&@&&,*********&***#&%***@**//////// /           
           //.////////**@&&*&&/&&(&&**********@***#&%***@/*/////// ///          
   *****   /// ///////***&&&&&*&&&&************&/******&**///////,,///  *****   
   *****    ///%%//////*****,#%(,*****************,,,****///////%%///   *****.  
             /#%%%%#/////********//*,********,*********////////%%%/*            
            .%%%%%%%%%%(////(%%%%%%(         *%%%%%#/////////#%%%%%,            
            %%%%%%%%%%%%%%%%%%%%%%%%         %%%%%%%%%%%%%%%%%%%%%%%%           
            #%%%%%%%%%%%%%%%%%%%%%%%%%%&%%%%%%%%%%%%%%%%%%%%%%%%%%%%%           
              (%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*              
              (%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%               
               (%%&%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*  &%&                
                    %%%% %%%%%.       #%%%%%      %%%%  (%*                     
                           #%%                      /                           
                                                                                
                                 _  ___  ____  _____ 
                                | |/ _ \/ ___||  ___|
                             _  | | | | \___ \| |_   
                            | |_| | |_| |___) |  _|  
                             \___/ \___/|____/|_|    

                      ____ _____  _    ____ _____ _____ ____  
                     / ___|_   _|/ \  |  _ |_   _| ____|  _ \ 
                     \___ \ | | / _ \ | |_) || | |  _| | | | |
                      ___) || |/ ___ \|  _ < | | | |___| |_| |
                     |____/ |_/_/   \_|_| \_\|_| |_____|____/ 
                                         
                       
                       "
  try {
	$ScriptDir = Split-Path -Parent $MyInvocation.MyCommand.Definition
	$ParentFolder = (Resolve-Path "$ScriptDir\..").Path
	$ClassesDir = Join-Path -Path $ParentFolder -ChildPath "\action-packs\"
	$Classpath = $josfVersion + ";" + $ClassesDir + "custom;" + $ClassesDir + "api;" + $ClassesDir + "selenese;" + $ClassesDir + "database;" + $ClassesDir + "accessibility;" + $ClassesDir + "files;"
	Write-Host $Classpath
	.\jre\bin\java.exe -cp "$Classpath" io.vertx.core.Launcher -conf config.json
  }
  catch {
    Write-Error "You need Java JRE 21 for JOSF.\nPlease download the correct version from https://www.java.com/download/";
    Start-Sleep -s 2;
    Pause;
  }
}
catch {
  Write-Error "Something went wrong during startup";
  Start-Sleep -s 2;
  Pause;

}
# SIG # Begin signature block
# MIIpjAYJKoZIhvcNAQcCoIIpfTCCKXkCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCA3SPqGUJF/aGHR
# pH++PQEz6Op4G5TGxf9T3JhqOw/dx6CCEnowggVvMIIEV6ADAgECAhBI/JO0YFWU
# jTanyYqJ1pQWMA0GCSqGSIb3DQEBDAUAMHsxCzAJBgNVBAYTAkdCMRswGQYDVQQI
# DBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcMB1NhbGZvcmQxGjAYBgNVBAoM
# EUNvbW9kbyBDQSBMaW1pdGVkMSEwHwYDVQQDDBhBQUEgQ2VydGlmaWNhdGUgU2Vy
# dmljZXMwHhcNMjEwNTI1MDAwMDAwWhcNMjgxMjMxMjM1OTU5WjBWMQswCQYDVQQG
# EwJHQjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMS0wKwYDVQQDEyRTZWN0aWdv
# IFB1YmxpYyBDb2RlIFNpZ25pbmcgUm9vdCBSNDYwggIiMA0GCSqGSIb3DQEBAQUA
# A4ICDwAwggIKAoICAQCN55QSIgQkdC7/FiMCkoq2rjaFrEfUI5ErPtx94jGgUW+s
# hJHjUoq14pbe0IdjJImK/+8Skzt9u7aKvb0Ffyeba2XTpQxpsbxJOZrxbW6q5KCD
# J9qaDStQ6Utbs7hkNqR+Sj2pcaths3OzPAsM79szV+W+NDfjlxtd/R8SPYIDdub7
# P2bSlDFp+m2zNKzBenjcklDyZMeqLQSrw2rq4C+np9xu1+j/2iGrQL+57g2extme
# me/G3h+pDHazJyCh1rr9gOcB0u/rgimVcI3/uxXP/tEPNqIuTzKQdEZrRzUTdwUz
# T2MuuC3hv2WnBGsY2HH6zAjybYmZELGt2z4s5KoYsMYHAXVn3m3pY2MeNn9pib6q
# RT5uWl+PoVvLnTCGMOgDs0DGDQ84zWeoU4j6uDBl+m/H5x2xg3RpPqzEaDux5mcz
# mrYI4IAFSEDu9oJkRqj1c7AGlfJsZZ+/VVscnFcax3hGfHCqlBuCF6yH6bbJDoEc
# QNYWFyn8XJwYK+pF9e+91WdPKF4F7pBMeufG9ND8+s0+MkYTIDaKBOq3qgdGnA2T
# OglmmVhcKaO5DKYwODzQRjY1fJy67sPV+Qp2+n4FG0DKkjXp1XrRtX8ArqmQqsV/
# AZwQsRb8zG4Y3G9i/qZQp7h7uJ0VP/4gDHXIIloTlRmQAOka1cKG8eOO7F/05QID
# AQABo4IBEjCCAQ4wHwYDVR0jBBgwFoAUoBEKIz6W8Qfs4q8p74Klf9AwpLQwHQYD
# VR0OBBYEFDLrkpr/NZZILyhAQnAgNpFcF4XmMA4GA1UdDwEB/wQEAwIBhjAPBgNV
# HRMBAf8EBTADAQH/MBMGA1UdJQQMMAoGCCsGAQUFBwMDMBsGA1UdIAQUMBIwBgYE
# VR0gADAIBgZngQwBBAEwQwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybC5jb21v
# ZG9jYS5jb20vQUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNAYIKwYBBQUHAQEE
# KDAmMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5jb21vZG9jYS5jb20wDQYJKoZI
# hvcNAQEMBQADggEBABK/oe+LdJqYRLhpRrWrJAoMpIpnuDqBv0WKfVIHqI0fTiGF
# OaNrXi0ghr8QuK55O1PNtPvYRL4G2VxjZ9RAFodEhnIq1jIV9RKDwvnhXRFAZ/ZC
# J3LFI+ICOBpMIOLbAffNRk8monxmwFE2tokCVMf8WPtsAO7+mKYulaEMUykfb9gZ
# pk+e96wJ6l2CxouvgKe9gUhShDHaMuwV5KZMPWw5c9QLhTkg4IUaaOGnSDip0TYl
# d8GNGRbFiExmfS9jzpjoad+sPKhdnckcW67Y8y90z7h+9teDnRGWYpquRRPaf9xH
# +9/DUp/mBlXpnYzyOmJRvOwkDynUWICE5EV7WtgwggYcMIIEBKADAgECAhAz1wio
# kUBTGeKlu9M5ua1uMA0GCSqGSIb3DQEBDAUAMFYxCzAJBgNVBAYTAkdCMRgwFgYD
# VQQKEw9TZWN0aWdvIExpbWl0ZWQxLTArBgNVBAMTJFNlY3RpZ28gUHVibGljIENv
# ZGUgU2lnbmluZyBSb290IFI0NjAeFw0yMTAzMjIwMDAwMDBaFw0zNjAzMjEyMzU5
# NTlaMFcxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxLjAs
# BgNVBAMTJVNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBDQSBFViBSMzYwggGi
# MA0GCSqGSIb3DQEBAQUAA4IBjwAwggGKAoIBgQC70f4et0JbePWQp64sg/GNIdMw
# hoV739PN2RZLrIXFuwHP4owoEXIEdiyBxasSekBKxRDogRQ5G19PB/YwMDB/NSXl
# wHM9QAmU6Kj46zkLVdW2DIseJ/jePiLBv+9l7nPuZd0o3bsffZsyf7eZVReqskmo
# PBBqOsMhspmoQ9c7gqgZYbU+alpduLyeE9AKnvVbj2k4aOqlH1vKI+4L7bzQHkND
# brBTjMJzKkQxbr6PuMYC9ruCBBV5DFIg6JgncWHvL+T4AvszWbX0w1Xn3/YIIq62
# 0QlZ7AGfc4m3Q0/V8tm9VlkJ3bcX9sR0gLqHRqwG29sEDdVOuu6MCTQZlRvmcBME
# Jd+PuNeEM4xspgzraLqVT3xE6NRpjSV5wyHxNXf4T7YSVZXQVugYAtXueciGoWnx
# G06UE2oHYvDQa5mll1CeHDOhHu5hiwVoHI717iaQg9b+cYWnmvINFD42tRKtd3V6
# zOdGNmqQU8vGlHHeBzoh+dYyZ+CcblSGoGSgg8sCAwEAAaOCAWMwggFfMB8GA1Ud
# IwQYMBaAFDLrkpr/NZZILyhAQnAgNpFcF4XmMB0GA1UdDgQWBBSBMpJBKyjNRsjE
# osYqORLsSKk/FDAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/BAgwBgEB/wIBADAT
# BgNVHSUEDDAKBggrBgEFBQcDAzAaBgNVHSAEEzARMAYGBFUdIAAwBwYFZ4EMAQMw
# SwYDVR0fBEQwQjBAoD6gPIY6aHR0cDovL2NybC5zZWN0aWdvLmNvbS9TZWN0aWdv
# UHVibGljQ29kZVNpZ25pbmdSb290UjQ2LmNybDB7BggrBgEFBQcBAQRvMG0wRgYI
# KwYBBQUHMAKGOmh0dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0Nv
# ZGVTaWduaW5nUm9vdFI0Ni5wN2MwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLnNl
# Y3RpZ28uY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBfNqz7+fZyWhS38Asd3tj9lwHS
# /QHumS2G6Pa38Dn/1oFKWqdCSgotFZ3mlP3FaUqy10vxFhJM9r6QZmWLLXTUqwj3
# ahEDCHd8vmnhsNufJIkD1t5cpOCy1rTP4zjVuW3MJ9bOZBHoEHJ20/ng6SyJ6UnT
# s5eWBgrh9grIQZqRXYHYNneYyoBBl6j4kT9jn6rNVFRLgOr1F2bTlHH9nv1HMePp
# GoYd074g0j+xUl+yk72MlQmYco+VAfSYQ6VK+xQmqp02v3Kw/Ny9hA3s7TSoXpUr
# OBZjBXXZ9jEuFWvilLIq0nQ1tZiao/74Ky+2F0snbFrmuXZe2obdq2TWauqDGIgb
# MYL1iLOUJcAhLwhpAuNMu0wqETDrgXkG4UGVKtQg9guT5Hx2DJ0dJmtfhAH2KpnN
# r97H8OQYok6bLyoMZqaSdSa+2UA1E2+upjcaeuitHFFjBypWBmztfhj24+xkc6Zt
# CDaLrw+ZrnVrFyvCTWrDUUZBVumPwo3/E3Gb2u2e05+r5UWmEsUUWlJBl6MGAAjF
# 5hzqJ4I8O9vmRsTvLQA1E802fZ3lqicIBczOwDYOSxlP0GOabb/FKVMxItt1UHeG
# 0PL4au5rBhs+hSMrl8h+eplBDN1Yfw6owxI9OjWb4J0sjBeBVESoeh2YnZZ/WVim
# VGX/UUIL+Efrz/jlvzCCBuMwggVLoAMCAQICEQDXXshYYnQ6pRPT9Ie5aFJXMA0G
# CSqGSIb3DQEBCwUAMFcxCzAJBgNVBAYTAkdCMRgwFgYDVQQKEw9TZWN0aWdvIExp
# bWl0ZWQxLjAsBgNVBAMTJVNlY3RpZ28gUHVibGljIENvZGUgU2lnbmluZyBDQSBF
# ViBSMzYwHhcNMjMwNzE4MDAwMDAwWhcNMjYwNzE3MjM1OTU5WjCByjERMA8GA1UE
# BRMIMzAxOTA1MzExEzARBgsrBgEEAYI3PAIBAxMCTkwxHTAbBgNVBA8TFFByaXZh
# dGUgT3JnYW5pemF0aW9uMQswCQYDVQQGEwJOTDEQMA4GA1UECAwHVXRyZWNodDEw
# MC4GA1UECgwnVmFsb3JpIFF1YWxpdHkgQXNzdXJhbmNlICYgVGVzdGluZyBCLlYu
# MTAwLgYDVQQDDCdWYWxvcmkgUXVhbGl0eSBBc3N1cmFuY2UgJiBUZXN0aW5nIEIu
# Vi4wggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC4kUjt587La0p1C0LU
# 4DO7qy514wk6aAdFtTrEqXwtgRrh57Qx5jXO2MapWruF962i2Sl+MdgvrFRR19Ky
# 4l+d/xtsQzrp2ZfxlksYCaiXj8PEqiABKWXNLHsAhd9Q2BFJP3r7VdaT/08afU54
# mb++GwivFm70nhU6j2AXfFv9JIV+0EIxMrGz9fIiZRtflrM5sx12cHO7XRl/r2cG
# ZIx5g7jgH2+btOWk4wB6SmqQKkhdqTgOCvQ5rfqOYJg2aZAVjPyaJZby4rEpnnpd
# x/NqLZbs2mWfAg1zlhXRz293ZxiqRnDTjUULucTJa46ovQkZmmgt+rGYrfFKDKsr
# JpAxgV9HeJGVTNesxu01ErYE4ECtHYck5sa5UeYuhGY3JHT8qPCsrVhpehai0nZ1
# Mgv+8pime4HltFb3HpQ99cJOcki4vah3II8USlnLPUsCHXBeSBn9kzO9rwBYwRw/
# sqbrkCmMO03LSk28VSyj0ntgzdVXJhRECd7N7qmtQfIKVJfsEJl2KITZBkeEZqKm
# tuLTzziP6n/SqtE+nqFX9QnXEr2jK+Ikm1ls76VBgEIh/GNW+HnQc3GdpENVXgj/
# PlAdnEfmbbBSC6DMWMxIaC7IKBqQQGWU82SiVmjq8AghWiOm5+xMOG0DLRkuvX6Q
# Kix+1rcYq5oQ9dWGhDQaJG3mbwIDAQABo4IBtDCCAbAwHwYDVR0jBBgwFoAUgTKS
# QSsozUbIxKLGKjkS7EipPxQwHQYDVR0OBBYEFGiXG3qH53ofjQxesyqsZzlvA/sl
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBMGA1UdJQQMMAoGCCsGAQUF
# BwMDMEkGA1UdIARCMEAwNQYMKwYBBAGyMQECAQYBMCUwIwYIKwYBBQUHAgEWF2h0
# dHBzOi8vc2VjdGlnby5jb20vQ1BTMAcGBWeBDAEDMEsGA1UdHwREMEIwQKA+oDyG
# Omh0dHA6Ly9jcmwuc2VjdGlnby5jb20vU2VjdGlnb1B1YmxpY0NvZGVTaWduaW5n
# Q0FFVlIzNi5jcmwwewYIKwYBBQUHAQEEbzBtMEYGCCsGAQUFBzAChjpodHRwOi8v
# Y3J0LnNlY3RpZ28uY29tL1NlY3RpZ29QdWJsaWNDb2RlU2lnbmluZ0NBRVZSMzYu
# Y3J0MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTAmBgNVHREE
# HzAdoBsGCCsGAQUFBwgDoA8wDQwLTkwtMzAxOTA1MzEwDQYJKoZIhvcNAQELBQAD
# ggGBAImy2ckYiM+JHIBoYKF/5ALoFUHVFf/gBPRN9zKu2/79wloAZJpm5EhUreCi
# AHoDnW7mdFocKG/9esjZ2m3JW6ZOYLArBumuBkNJLJYDO7Q8mCJnthmM7IwKFBQJ
# mMoe00Mwz4Jn5/zXU8Ev40ZdkSpVgmmV3qnMfwid9w+ZUuP6GKz+VTY90S5vU/vV
# Su+hwZC07+BvJ0/5IliZTKWNF9hMOrAvLZBcmi1TTZt8sFUjWHllfSbHRAlA/Ai0
# nfcrJsEAZRQwJ4PCKKQrvGPJJhb4y9owlJPG0QfCLoApVZ9iqEqp+bto/gKFrjxj
# mYLhZQpDc1wYTsE8dIou8aiaXYDSBe59XcdSBfCcAWn42y26DwcWrd6P+Orvf0wb
# NcJDxtFUaWVM39q1y9yLfKekWeugYR+XIUQcWdPltWlQQddDr6kVoP7clCdVbPxT
# 0gD2uDQvpoiejiEKsYU+B8op7Qf8QzJ2Lx9+ptncYhmLk7QlyYG6E8C8K7CFIoXx
# gZ/+9jGCFmgwghZkAgEBMGwwVzELMAkGA1UEBhMCR0IxGDAWBgNVBAoTD1NlY3Rp
# Z28gTGltaXRlZDEuMCwGA1UEAxMlU2VjdGlnbyBQdWJsaWMgQ29kZSBTaWduaW5n
# IENBIEVWIFIzNgIRANdeyFhidDqlE9P0h7loUlcwDQYJYIZIAWUDBAIBBQCgfDAQ
# BgorBgEEAYI3AgEMMQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgor
# BgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAvBgkqhkiG9w0BCQQxIgQgK5dydkc2
# 8Gmx12bP5W+sbe8hYShED4pikGX4a3e+zSUwDQYJKoZIhvcNAQEBBQAEggIADZSC
# XkZ9imq4Kf2/Du998tC3SOGcXU7Xz9OEXbF08AENYJsC6oBtg8o6X3fTfy47rW15
# Q0l7v0PDA2aM8n6tGzvWDg0q5LPDo40XXd1r9IiQ267fLMjetNfHnTVjyNc/x84H
# zQzBTcy5pepfnsFpd/HOm/ypw6B7BO/mvV6pQ6m5ERobD/e8RTShfSQG9QrU/RdF
# 4AHIm2yaeqnP7DhQ5TSJwjyM33nnzwG3DrRWwT094hXaH6grtTKsXVuIVd/nrOcb
# lfPM8T2P4qIKTEclyUol+mohepqz3KoJ/j/cpCLDjRP/jwANK2nqMoVbluFGxoYI
# FTYSz6bleBVjgOASHNUqbNHYfqkDJTtofRZ2RWrQQplX77Xd/TjFNbssQ5D5oML8
# V6UQStsWhMGNoXBxd8ymnYHRuyH9BepZU8L7kpcbarl2srhMhNK3P6J5D09dBiZz
# ijWyfgIcUH7gCfsGdx3tv3KvkqjcxewPppwtab4i365DnkoJGEUICFsMVdeZIjvM
# wcwll1QiBLnXFN0yBErqnDZbyir779EY9MSKc7kJ+mlV960bvaVYZWc4S5JP1w3X
# sccPfhgSOnLPsLJ1PnTh+IVx2VnsCE4/anreW3/RsfGMAZ1dFOTrHlrOSr97fnkc
# xFjjKWXe4Q4Dd9CFhsXr11qvyyuN+nzrjRp2zPWhghNPMIITSwYKKwYBBAGCNwMD
# ATGCEzswghM3BgkqhkiG9w0BBwKgghMoMIITJAIBAzEPMA0GCWCGSAFlAwQCAgUA
# MIHwBgsqhkiG9w0BCRABBKCB4ASB3TCB2gIBAQYKKwYBBAGyMQIBATAxMA0GCWCG
# SAFlAwQCAQUABCCv+ktTB/JtqMrokh0UlkSrcGsDRflGaS3yVGGoN3A9hQIVAMjk
# 5Rt+36c2lgHVEh+A0toqIGn3GA8yMDI0MDcwOTEyMjg0N1qgbqRsMGoxCzAJBgNV
# BAYTAkdCMRMwEQYDVQQIEwpNYW5jaGVzdGVyMRgwFgYDVQQKEw9TZWN0aWdvIExp
# bWl0ZWQxLDAqBgNVBAMMI1NlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcgU2lnbmVy
# ICM0oIIN6TCCBvUwggTdoAMCAQICEDlMJeF8oG0nqGXiO9kdItQwDQYJKoZIhvcN
# AQEMBQAwfTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
# cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSUw
# IwYDVQQDExxTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5nIENBMB4XDTIzMDUwMzAw
# MDAwMFoXDTM0MDgwMjIzNTk1OVowajELMAkGA1UEBhMCR0IxEzARBgNVBAgTCk1h
# bmNoZXN0ZXIxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDEsMCoGA1UEAwwjU2Vj
# dGlnbyBSU0EgVGltZSBTdGFtcGluZyBTaWduZXIgIzQwggIiMA0GCSqGSIb3DQEB
# AQUAA4ICDwAwggIKAoICAQCkkyhSS88nh3akKRyZOMDnDtTRHOxoywFk5IrNd7Bx
# ZYK8n/yLu7uVmPslEY5aiAlmERRYsroiW+b2MvFdLcB6og7g4FZk7aHlgSByIGRB
# bMfDCPrzfV3vIZrCftcsw7oRmB780yAIQrNfv3+IWDKrMLPYjHqWShkTXKz856vp
# HBYusLA4lUrPhVCrZwMlobs46Q9vqVqakSgTNbkf8z3hJMhrsZnoDe+7TeU9jFQD
# kdD8Lc9VMzh6CRwH0SLgY4anvv3Sg3MSFJuaTAlGvTS84UtQe3LgW/0Zux88ahl7
# brstRCq+PEzMrIoEk8ZXhqBzNiuBl/obm36Ih9hSeYn+bnc317tQn/oYJU8T8l58
# qbEgWimro0KHd+D0TAJI3VilU6ajoO0ZlmUVKcXtMzAl5paDgZr2YGaQWAeAzUJ1
# rPu0kdDF3QFAaraoEO72jXq3nnWv06VLGKEMn1ewXiVHkXTNdRLRnG/kXg2b7HUm
# 7v7T9ZIvUoXo2kRRKqLMAMqHZkOjGwDvorWWnWKtJwvyG0rJw5RCN4gghKiHrsO6
# I3J7+FTv+GsnsIX1p0OF2Cs5dNtadwLRpPr1zZw9zB+uUdB7bNgdLRFCU3F0wuU1
# qi1SEtklz/DT0JFDEtcyfZhs43dByP8fJFTvbq3GPlV78VyHOmTxYEsFT++5L+wJ
# EwIDAQABo4IBgjCCAX4wHwYDVR0jBBgwFoAUGqH4YRkgD8NBd0UojtE1XwYSBFUw
# HQYDVR0OBBYEFAMPMciRKpO9Y/PRXU2kNA/SlQEYMA4GA1UdDwEB/wQEAwIGwDAM
# BgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMEoGA1UdIARDMEEw
# NQYMKwYBBAGyMQECAQMIMCUwIwYIKwYBBQUHAgEWF2h0dHBzOi8vc2VjdGlnby5j
# b20vQ1BTMAgGBmeBDAEEAjBEBgNVHR8EPTA7MDmgN6A1hjNodHRwOi8vY3JsLnNl
# Y3RpZ28uY29tL1NlY3RpZ29SU0FUaW1lU3RhbXBpbmdDQS5jcmwwdAYIKwYBBQUH
# AQEEaDBmMD8GCCsGAQUFBzAChjNodHRwOi8vY3J0LnNlY3RpZ28uY29tL1NlY3Rp
# Z29SU0FUaW1lU3RhbXBpbmdDQS5jcnQwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3Nw
# LnNlY3RpZ28uY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBMm2VY+uB5z+8VwzJt3jOR
# 63dY4uu9y0o8dd5+lG3DIscEld9laWETDPYMnvWJIF7Bh8cDJMrHpfAm3/j4MWUN
# 4OttUVemjIRSCEYcKsLe8tqKRfO+9/YuxH7t+O1ov3pWSOlh5Zo5d7y+upFkiHX/
# XYUWNCfSKcv/7S3a/76TDOxtog3Mw/FuvSGRGiMAUq2X1GJ4KoR5qNc9rCGPcMMk
# eTqX8Q2jo1tT2KsAulj7NYBPXyhxbBlewoNykK7gxtjymfvqtJJlfAd8NUQdrVgY
# a2L73mzECqls0yFGcNwvjXVMI8JB0HqWO8NL3c2SJnR2XDegmiSeTl9O048P5RNP
# WURlS0Nkz0j4Z2e5Tb/MDbE6MNChPUitemXk7N/gAfCzKko5rMGk+al9NdAyQKCx
# GSoYIbLIfQVxGksnNqrgmByDdefHfkuEQ81D+5CXdioSrEDBcFuZCkD6gG2UYXvI
# brnIZ2ckXFCNASDeB/cB1PguEc2dg+X4yiUcRD0n5bCGRyoLG4R2fXtoT4239xO0
# 7aAt7nMP2RC6nZksfNd1H48QxJTmfiTllUqIjCfWhWYd+a5kdpHoSP7IVQrtKcMf
# 3jimwBT7Mj34qYNiNsjDvgCHHKv6SkIciQPc9Vx8cNldeE7un14g5glqfCsIo0j1
# FfwET9/NIRx65fWOGtS5QDCCBuwwggTUoAMCAQICEDAPb6zdZph0fKlGNqd4Lbkw
# DQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpOZXcgSmVy
# c2V5MRQwEgYDVQQHEwtKZXJzZXkgQ2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVT
# VCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNBIENlcnRpZmljYXRpb24g
# QXV0aG9yaXR5MB4XDTE5MDUwMjAwMDAwMFoXDTM4MDExODIzNTk1OVowfTELMAkG
# A1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMH
# U2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSUwIwYDVQQDExxTZWN0
# aWdvIFJTQSBUaW1lIFN0YW1waW5nIENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8A
# MIICCgKCAgEAyBsBr9ksfoiZfQGYPyCQvZyAIVSTuc+gPlPvs1rAdtYaBKXOR4O1
# 68TMSTTL80VlufmnZBYmCfvVMlJ5LsljwhObtoY/AQWSZm8hq9VxEHmH9EYqzcRa
# ydvXXUlNclYP3MnjU5g6Kh78zlhJ07/zObu5pCNCrNAVw3+eolzXOPEWsnDTo8Tf
# s8VyrC4Kd/wNlFK3/B+VcyQ9ASi8Dw1Ps5EBjm6dJ3VV0Rc7NCF7lwGUr3+Az9ER
# CleEyX9W4L1GnIK+lJ2/tCCwYH64TfUNP9vQ6oWMilZx0S2UTMiMPNMUopy9Jv/T
# UyDHYGmbWApU9AXn/TGs+ciFF8e4KRmkKS9G493bkV+fPzY+DjBnK0a3Na+WvtpM
# YMyou58NFNQYxDCYdIIhz2JWtSFzEh79qsoIWId3pBXrGVX/0DlULSbuRRo6b83X
# hPDX8CjFT2SDAtT74t7xvAIo9G3aJ4oG0paH3uhrDvBbfel2aZMgHEqXLHcZK5OV
# mJyXnuuOwXhWxkQl3wYSmgYtnwNe/YOiU2fKsfqNoWTJiJJZy6hGwMnypv99V9sS
# dvqKQSTUG/xypRSi1K1DHKRJi0E5FAMeKfobpSKupcNNgtCN2mu32/cYQFdz8HGj
# +0p9RTbB942C+rnJDVOAffq2OVgy728YUInXT50zvRq1naHelUF6p4MCAwEAAaOC
# AVowggFWMB8GA1UdIwQYMBaAFFN5v1qqK0rPVIDh2JvAnfKyA2bLMB0GA1UdDgQW
# BBQaofhhGSAPw0F3RSiO0TVfBhIEVTAOBgNVHQ8BAf8EBAMCAYYwEgYDVR0TAQH/
# BAgwBgEB/wIBADATBgNVHSUEDDAKBggrBgEFBQcDCDARBgNVHSAECjAIMAYGBFUd
# IAAwUAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC51c2VydHJ1c3QuY29tL1VT
# RVJUcnVzdFJTQUNlcnRpZmljYXRpb25BdXRob3JpdHkuY3JsMHYGCCsGAQUFBwEB
# BGowaDA/BggrBgEFBQcwAoYzaHR0cDovL2NydC51c2VydHJ1c3QuY29tL1VTRVJU
# cnVzdFJTQUFkZFRydXN0Q0EuY3J0MCUGCCsGAQUFBzABhhlodHRwOi8vb2NzcC51
# c2VydHJ1c3QuY29tMA0GCSqGSIb3DQEBDAUAA4ICAQBtVIGlM10W4bVTgZF13wN6
# MgstJYQRsrDbKn0qBfW8Oyf0WqC5SVmQKWxhy7VQ2+J9+Z8A70DDrdPi5Fb5WEHP
# 8ULlEH3/sHQfj8ZcCfkzXuqgHCZYXPO0EQ/V1cPivNVYeL9IduFEZ22PsEMQD43k
# +ThivxMBxYWjTMXMslMwlaTW9JZWCLjNXH8Blr5yUmo7Qjd8Fng5k5OUm7Hcsm1B
# bWfNyW+QPX9FcsEbI9bCVYRm5LPFZgb289ZLXq2jK0KKIZL+qG9aJXBigXNjXqC7
# 2NzXStM9r4MGOBIdJIct5PwC1j53BLwENrXnd8ucLo0jGLmjwkcd8F3WoXNXBWia
# p8k3ZR2+6rzYQoNDBaWLpgn/0aGUpk6qPQn1BWy30mRa2Coiwkud8TleTN5IPZs0
# lpoJX47997FSkc4/ifYcobWpdR9xv1tDXWU9UIFuq/DQ0/yysx+2mZYm9Dx5i1xk
# zM3uJ5rloMAMcofBbk1a0x7q8ETmMm8c6xdOlMN4ZSA7D0GqH+mhQZ3+sbigZSo0
# 4N6o+TzmwTC7wKBjLPxcFgCo0MR/6hGdHgbGpm0yXbQ4CStJB6r97DDa8acvz7f9
# +tCjhNknnvsBZne5VhDhIG7GrrH5trrINV0zdo7xfCAMKneutaIChrop7rRaALGM
# q+P5CslUXdS5anSevUiumDGCBCwwggQoAgEBMIGRMH0xCzAJBgNVBAYTAkdCMRsw
# GQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNVBAcTB1NhbGZvcmQxGDAW
# BgNVBAoTD1NlY3RpZ28gTGltaXRlZDElMCMGA1UEAxMcU2VjdGlnbyBSU0EgVGlt
# ZSBTdGFtcGluZyBDQQIQOUwl4XygbSeoZeI72R0i1DANBglghkgBZQMEAgIFAKCC
# AWswGgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0y
# NDA3MDkxMjI4NDdaMD8GCSqGSIb3DQEJBDEyBDCgir/Xz21QszdSUo2EuYLbdxkk
# fCQWJk1N52cMSNLAlefuFFMtABXSVVGBkyy+y5Qwge0GCyqGSIb3DQEJEAIMMYHd
# MIHaMIHXMBYEFK5ir3UKDL1H1kYfdWjivIznyk+UMIG8BBQC1luV4oNwwVcAlfqI
# +SPdk3+tjzCBozCBjqSBizCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBK
# ZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4wHAYDVQQKExVUaGUgVVNFUlRS
# VVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVTRVJUcnVzdCBSU0EgQ2VydGlmaWNhdGlv
# biBBdXRob3JpdHkCEDAPb6zdZph0fKlGNqd4LbkwDQYJKoZIhvcNAQEBBQAEggIA
# jFjDAuJm4sZSSP3g9eumqoHakF0m57Brsb5khPVwhetGbYsXvJAG4udWdRO+Csk9
# YeqJgF/wGzFobrL6sgyBgeB07WAGbnqKAna7nPTEftjQncX77NJPeA5yKuN4EQ0x
# nQQ2yFhix+6cChQ3d6davedFOt26xa/gN9tNZFWsu7upgvfwgqE/Hr/lZ3MiI33q
# emsxbqP4s3+AzCNt91/RHTQaMx8BzyP7sGMXKHDlMQIgifFYq3V42K1G2T8GTEeM
# ekjM2k3LR1c0rYjKZ7n/YvHx2g++sDxohSpd2xYM65Qo1+tViIKHbO0hUtqho5b9
# 8jJdMTZpSNTgYzpuH1ESYwQ5/6klj4UojLXYrxSKlfK2RQ6Q3gFeqVo1EuJtqzVy
# 9UDAPZmNePxp11122XD+r+rli3D4cg8xHzjMwCSZ2MBhLWGr0ibkCX6/HTcoqL/R
# NOpmDHPjXd9P0XbhPMkpktisLkkBcFNglnLnLz25b6E9s9mAVITsnmkKlXdTXSCT
# Hwdwcx1JbZxsOWdPh5FPFjBEAlFTgBpxqlU1MSx7Wokrg7HmB1hfzsdEKWDlSUcN
# /hvgkCzHGIpgNBeFQ40+yvlnvtVbi3QvFIS3qgOFJp7FcjQCawXFrIQ29N1R7P3f
# pu1NORvwjDk8P6lhBWLOkDxWoN1E8W88hrLn+zijTK0=
# SIG # End signature block
