import { t } from '../../../../@vscode/l10n/dist/browser.js';

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
class CSSIssueType {
    constructor(id, message) {
        this.id = id;
        this.message = message;
    }
}
const ParseError = {
    NumberExpected: new CSSIssueType('css-numberexpected', t("number expected")),
    ConditionExpected: new CSSIssueType('css-conditionexpected', t("condition expected")),
    RuleOrSelectorExpected: new CSSIssueType('css-ruleorselectorexpected', t("at-rule or selector expected")),
    DotExpected: new CSSIssueType('css-dotexpected', t("dot expected")),
    ColonExpected: new CSSIssueType('css-colonexpected', t("colon expected")),
    SemiColonExpected: new CSSIssueType('css-semicolonexpected', t("semi-colon expected")),
    TermExpected: new CSSIssueType('css-termexpected', t("term expected")),
    ExpressionExpected: new CSSIssueType('css-expressionexpected', t("expression expected")),
    OperatorExpected: new CSSIssueType('css-operatorexpected', t("operator expected")),
    IdentifierExpected: new CSSIssueType('css-identifierexpected', t("identifier expected")),
    PercentageExpected: new CSSIssueType('css-percentageexpected', t("percentage expected")),
    URIOrStringExpected: new CSSIssueType('css-uriorstringexpected', t("uri or string expected")),
    URIExpected: new CSSIssueType('css-uriexpected', t("URI expected")),
    VariableNameExpected: new CSSIssueType('css-varnameexpected', t("variable name expected")),
    VariableValueExpected: new CSSIssueType('css-varvalueexpected', t("variable value expected")),
    PropertyValueExpected: new CSSIssueType('css-propertyvalueexpected', t("property value expected")),
    LeftCurlyExpected: new CSSIssueType('css-lcurlyexpected', t("{ expected")),
    RightCurlyExpected: new CSSIssueType('css-rcurlyexpected', t("} expected")),
    LeftSquareBracketExpected: new CSSIssueType('css-rbracketexpected', t("[ expected")),
    RightSquareBracketExpected: new CSSIssueType('css-lbracketexpected', t("] expected")),
    LeftParenthesisExpected: new CSSIssueType('css-lparentexpected', t("( expected")),
    RightParenthesisExpected: new CSSIssueType('css-rparentexpected', t(") expected")),
    CommaExpected: new CSSIssueType('css-commaexpected', t("comma expected")),
    PageDirectiveOrDeclarationExpected: new CSSIssueType('css-pagedirordeclexpected', t("page directive or declaraton expected")),
    UnknownAtRule: new CSSIssueType('css-unknownatrule', t("at-rule unknown")),
    UnknownKeyword: new CSSIssueType('css-unknownkeyword', t("unknown keyword")),
    SelectorExpected: new CSSIssueType('css-selectorexpected', t("selector expected")),
    StringLiteralExpected: new CSSIssueType('css-stringliteralexpected', t("string literal expected")),
    WhitespaceExpected: new CSSIssueType('css-whitespaceexpected', t("whitespace expected")),
    MediaQueryExpected: new CSSIssueType('css-mediaqueryexpected', t("media query expected")),
    IdentifierOrWildcardExpected: new CSSIssueType('css-idorwildcardexpected', t("identifier or wildcard expected")),
    WildcardExpected: new CSSIssueType('css-wildcardexpected', t("wildcard expected")),
    IdentifierOrVariableExpected: new CSSIssueType('css-idorvarexpected', t("identifier or variable expected")),
};

export { CSSIssueType, ParseError };
